function [ZLP,ZLP_old,FWHM,Energies,ZLPLog,PreZLP,ZLPDrift,ZLPExp,Cut,Fine] = Load3DPeak(handles,image,tags,FileName)
%% Select ZLP region
% Allows the user to select a region in which all ZLP are to be found for
% faster alignment and to make the process less prone to cosmic rays.

%% Get Handles
GainChange= get(handles.CorrGainRef,'UserData');
image     = double(image);
EnergyRes = double(tags.ImageList.Unnamed1.ImageData.Calibrations.Dimension.Unnamed2.Scale.Value);
ZLPExp    = double(tags.ImageList.Unnamed1.ImageTags.SI.Acquisition.PixelTime0x28s0x29.Value);

Dark      = double(tags.ImageList.Unnamed1.ImageTags.EELS.Acquisition.HQDarkCorrection.OriginalDarkCorrection.Value);
HQAppl    = double(tags.ImageList.Unnamed1.ImageTags.EELS.Acquisition.HQDarkCorrection.Applied.Value);
try
    HQDark    = double(tags.ImageList.Unnamed1.ImageTags.EELS.Acquisition.HQDarkCorrection.HQDarkCorrection.Value);
    Frames    = double(tags.ImageList.Unnamed1.ImageTags.EELS.Acquisition.HQDarkCorrection.FramesAveraged.Value);
catch
    HQDark = [];
    Frames = [];
end

image     = round(image    ,8);                                            % for some reason 'double' adds numbers after the 8th decimal to the array
EnergyRes = round(EnergyRes,8);
HQDark    = reshape(HQDark,[1,1,size(HQDark,1)]);
Dark      = reshape(  Dark,[1,1,size(  Dark,1)]);

%% Calculate
if ~HQAppl && ~isempty(HQDark)
    hqdark = repmat(HQDark,[size(image,1),size(image,2),1]);
    dark   = repmat(  Dark,[size(image,1),size(image,2),1]);
    image  = image + dark - hqdark;
    clearvars hqdark dark
end

GainChange = repmat(GainChange,[size(image,1),size(image,2),1]);
image      = image./GainChange;


%% Saturation
CorrSat = get(handles.CorrSat,'UserData');

if ~isempty(CorrSat)
    ZLP2D    = get(handles.ZLP2D,'UserData');
    GainRef  = get(handles.Load2DRef,'UserData');
    GainRef  = GainRef{2};
    
    Sum      = sum(ZLP2D,2);
    dist     = Sum./sum(Sum,'all');
    Dist     = repmat(dist,[1,size(image,3)]);
    
    WaitTics = size(image,1)*size(image,2);
    Wait     = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
    for i=1:size(image,1)
        for j =1:size(image,2)
            spec         = reshape(image(i,j,:),[1,size(image,3)]);
            Img          = repmat(spec,[size(Dist,1),1]).*Dist;
            img          = round(  max(Img.*GainRef ,1)  );
            corr         = CorrSat(round(img));
            image(i,j,:) = round(sum(Img.*corr,1));
            Wait.Send
        end
    end
    Wait.Destroy;
end
%% Continue

Disp      = linspace(0,EnergyRes*(size(image,3)-1),size(image,3));
Energies  = zeros(1,size(image,3));
FWHM      = zeros(size(image,1),size(image,2));
maxEne    = max(image,[],3);
minEne    = min(image,[],3);
ZLP       =(minEne + maxEne) / 2;
ZLPDrift  = zeros([size(image,1),size(image,2)]);
Prec      = -round(log10(EnergyRes));

for i=1:size(image,1)
    parfor j=1:size(image,2)
        % Find where the data first drops below half the max.
        index1          = (find(image(i,j,:) >= ZLP(i,j), 1, 'first'));
        % Find where the data last rises above half the max.
        index2          = (find(image(i,j,:) >= ZLP(i,j), 1, 'last'));
        if index1~=index2
            FWHM(i,j)       = Disp(index2)-Disp(index1);
        else
            FWHM(i,j)       = NaN;
        end
        %% Correct Energies to first Pixel ZLP
        ZLPDrift(i,j)       = Disp(round((index1+index2)/2));
    end
end

Disp              = Disp-min(ZLPDrift,[],'all');
Energies(1,:)     = round(Disp,2);
FWHM(isnan(FWHM)) = mean(FWHM(~isnan(FWHM)),'all');
FWHM              = round(FWHM,Prec);
Spec              = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
Spec              = max(Spec,[],1);
fig               = figure('Name','Select region with ZLP for BroadAlign - double click to confirm!');

plot(Energies,Spec,'Color','b');
hold on
plot(Energies,zeros(size(Energies)),'--','Color','k');
hold off
legend('mean normed Spectrum');
ylabel( 'normed Counts [a.u.]' );
xlabel( 'Loss energy [eV]' );
ylim([-max(Spec)/2,max(Spec).*1.25]);
xlim([min(Energies,[],2),max(Energies,[],2)]);

maxEne            = max(Spec,[],2);
minEne            = min(Spec,[],2);
ZLP               = (minEne + maxEne) / 10;
index1            = (find(Spec >= ZLP, 1, 'first'));
index2            = (find(Spec >= ZLP, 1, 'last'));
Start             = Energies(index1)- mean(FWHM,'all')*2;
Width             = Energies(index2)- Start + mean(FWHM,'all')*2;
if Start+Width > Energies(end)
    Width = Energies(End)-Start;
end

try
    Select  = drawrectangle('Position',[Start,-max(Spec)/2,Width,max(Spec)/2+max(Spec).*1.25],'Color','b','StripeColor','w');
    l       = addlistener(Select,'ROIClicked',@(src,evt) DoubleClicker(src,evt));
    uiwait;
    pos     = Select.Position;
    Ind1    = pos(1);
    Ind2    = pos(1)+pos(3);
    Ind1    = find(Energies>=Ind1,1,'first');
    Ind2    = find(Energies<=Ind2,1,'last');
    delete(Select);
    close(fig);
    delete(l);
catch
    ZLP        = [];
    ZLP_old    = [];
    ZLPLog     = [];
    FWHM       = [];
    Energies   = [];
    PreZLP     = [];
    ZLPDrift   = [];
    ZLPExp     = [];
    Cut        = [];
    Fine     = [];
    clearvars -except ZLP ZLP_old ZLPLog FWHM Energies PreZLP ZLPDrift ZLPExp Cut Fine
    return
end

%% Remove Cosmic Rays from Darkframe
Count     = 0;
fig       = figure('Name','Select positions of "HQDark" Artifacts - select with click!');
NewHQDark = HQDark;
while 1
    try
        hqdark   = reshape(NewHQDark(1,1,:),[1,size(NewHQDark,3)]);
        dark     = reshape(Dark(1,1,:),[1,size(NewHQDark,3)]);
        Diff     = hqdark -dark;
        Max      = max(abs(Diff));
        set(fig,'WindowButtonMotionFcn',@(src,evt) RemArt1DDark(fig,src,evt,Energies,EnergyRes,hqdark,dark,'HQDark','Dark'));
        set(fig,'WindowButtonDownFcn',@(src,evt) Clicker(src,evt));
        plot(Energies,Diff)
        ylabel( 'Counts [a.u.]' );
        xlabel( 'Loss energy [eV]' );
        xlim([min(Energies),max(Energies)]);
        ylim([-1.5*Max,1.5*Max]);
        legend('Difference HQDark - Dark')
        uiwait;
        E = get(gca,'CurrentPoint');
        E = EnergyRes*round(E(1,1)./EnergyRes);
        if isvalid(fig)
            DelInd = zeros(1,size(E,1));
            Count = Count + length(DelInd);
            for i=1:length(DelInd)
                delind        = find(Energies>=E(i),1,'first');
                delind1       = max(1,delind-5);
                delind2       = min(size(hqdark,2),delind+5);
                Diff          = hqdark - dark;
                Deriv         = Diff(1,delind1:delind2) - circshift(Diff(1,delind1:delind2),+1,2) ;
                Deriv         = Deriv - circshift(Deriv,-1,2);
                Deriv         = Deriv(3:end-2);
                [~,Max]       = max(abs(Deriv),[],2);
                DelInd        = Max + delind1+1;
                New           = dark(1,DelInd);
                NewHQDark(:,:,DelInd) = New;
            end
        end
    catch
        break
    end
end
figure('Name','Select regions of "HQDark" Artifacts - select with click!');
while 1
    try
        hqdark  = reshape(NewHQDark(1,1,:),[1,size(NewHQDark,3)]);
        dark    = reshape(Dark(1,1,:),[1,size(Dark,3)]);
        Diff    = hqdark-dark;
        Max     = max(abs(Diff));
        plot(Energies,Diff)
        ylabel( 'Counts [a.u.]' );
        xlabel( 'Loss energy [eV]' );
        legend('Difference HQDark - Dark')
        xlim([min(Energies),max(Energies)]);
        ylim([-1.5*Max,1.5*Max]);
        Start   = 0;
        Width   = 5*mean(FWHM,'all');
        Select  = drawrectangle('Position',[Start-Width/2,-1.5*Max,Width,3*Max],'Color','b','StripeColor','w');
        l       = addlistener(Select,'ROIClicked',@(src,evt) DoubleClicker(src,evt));
        uiwait;
        pos     = Select.Position;
        Ind1    = pos(1);
        Ind2    = pos(1)+pos(3);
        Ind1    = find(Energies>=Ind1,1,'first');
        Ind2    = find(Energies<=Ind2,1,'last');
        
        NewHQDark(:,:,Ind1:Ind2) = Dark(:,:,Ind1:Ind2);
        Count = Count + Ind2-Ind1+1;
    catch
        delete(Select);
        delete(l);
        break
    end
end
if Count>0
    image = image + repmat(HQDark - NewHQDark,[size(image,1),size(image,2),1])./GainChange;
end

%% ZLP Alignment
% the ZLP is first defined by the maximum value inside the ZLP region. From
% there, the left and right half maxima positions are found. To the region between
% both half maxima a Gaussian function is fitted, which compares the Gauss peak position to the energy dispersion.
% The spectra are shifted circulary by their respective ZLP position in
% relation to the 0 position of the energy dispersion. The FWHM as a output
% parameter is kept, also the overall shift. Both can be seen in the
% FWHM and Drift map. However, with this curcular shift, shifts smaller
% than one dispersion step cannot be corrected. Thus the spectra is
% interpolated for higher precision alignment.
ZLP_old     = image;

[~,ZeroPos] = min(abs(Energies));
SizeX       = size(image,2);
SizeY       = size(image,1);
SizeZ       = size(image,3);

Kernel      = reshape(image(1,1,Ind1:Ind2),[1,size(image(:,:,Ind1:Ind2),3)]);
[~,Lag]     = CrossAlign(Kernel,Kernel);
[~,MaxPos]  = max(Kernel);
CorrShift   = ZeroPos-(MaxPos+Ind1-1);
Lag         = Lag - CorrShift;

image       = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
img         = image(:,Ind1:Ind2);
[CF,~]      = CrossAlign(img,Kernel);
[~,MaxPos]  = max(CF,[],2);
Shift       = Lag(1,MaxPos)';

parfor i=1:size(image,1)
    image(i,:)    = circshift(image(i,:),-Shift(i),2);
end

I          = sum(image,1);
[~,MaxPos] = max(I);
clearvars I

ShiftEnd   = ZeroPos - MaxPos;
image      = circshift(image,ShiftEnd,2);
Shift      = Shift - ShiftEnd;
image      = reshape(image,[SizeY,SizeX,SizeZ]);
Shift      = reshape(Shift,[SizeY,SizeX]);
DriftNew   = Shift.*EnergyRes;

Cut1         = floor(min((DriftNew),[],'all')/EnergyRes);
Cut2         =  ceil(max((DriftNew),[],'all')/EnergyRes);
EOld1        = Energies;

if Cut2>0
    image    = image(:,:,1:end-Cut2);
    Energies = Energies(:,1:end-Cut2);
else
    Cut2     = 0;
end
if Cut1<0
    image    = image(:,:,1-Cut1:end);
    Energies = Energies(:,1-Cut1:end);
    Cut1     = -Cut1;
else
    Cut1     = 0;
end

MaxDrift1    = max(abs(DriftNew),[],'all');
[row,col]    = find(abs(DriftNew)==MaxDrift1);
MaxDrift1    = DriftNew(row(1),col(1));

%% FineAlign ZLP
[image,Energies,DriftNew1,CutNew1,Cut2New,Fine,FineAlignLog] = FineAlignZLPLoad(image,Energies,FWHM,EnergyRes);
if isempty(Energies)
    msgbox('FineAligne failed!');
    ZLP      = [];
    ZLP_old  = [];
    FWHM     = [];
    ZLPLog   = [];
    Energies = [];
    PreZLP   = [];
    ZLPDrift = [];
    ZLPExp   = [];
    Cut      = [];
    Fine     = [];
    clearvars -except ZLP ZLP_old FWHM ZLPLog Energies PreZLP ZLPDrift ZLPExp Cut Fine
    return
end
ZLP   =  image;

%% Remove Artifacts
Cut1   = Cut1 + CutNew1;
Cut2   = Cut2 + Cut2New;
Cut    = [Cut1,Cut2];

ZLPDrift = DriftNew + DriftNew1;

[ZLP,ZLP_old,ArtifactsLog] = ArtifactsZLP(handles,ZLP,ZLP_old,Cut1,ZLPDrift,EnergyRes);
ZLP_old                    = ZLP_old(:,:,1+Cut1:Cut1+size(ZLP,3));

%% Select PreZLP
Zero = find(Energies>=0,1,'first');
fig  = figure('Name','Select upper boarder of PreZLP region - click to confirm!');
spec = sum(sum(ZLP,1),2);
spec = reshape(spec,[1,size(spec,3)]);

Min = min(spec,[],'all');
if Min<0
    spec = spec-Min+1;                                                     % to avoid log(0)
elseif Min==0
    spec=spec+1;
end

spec = real(log(spec));
plot(Energies(1,1:Zero),spec(1,1:Zero),'LineWidth',1.5,'Color','b');
hold on
plot(Energies(1,1:Zero),ones(1,Zero).*min(spec(1,1:Zero)),'--','Color','k');
ylabel( 'Log Counts [a.u.]' );
xlabel( 'Loss energy [eV]' );
legend('Log Spec')
xlim([min(Energies),0]);
hold off

try
    [PreZLP,~] = ginput(1);
    close(fig);
catch
    ZLP      = [];
    ZLP_old  = [];
    FWHM     = [];
    ZLPLog   = [];
    Energies = [];
    PreZLP   = [];
    ZLPDrift = [];
    ZLPExp   = [];
    Cut      = [];
    Fine     = [];
    clearvars -except ZLP ZLP_old FWHM ZLPLog Energies PreZLP PreZLP ZLPDrift ZLPExp Cut Fine
    return
end

%% Create Log
ZLPLog = {['3D ZLP: ',FileName]};
%BroadAlignLog
ZLPLog{end+1,1}= ['BroadAlign:  StartVal: ' , num2str(EOld1(Ind1)),'eV  |  EndVal: ', num2str(EOld1(Ind2)),'eV  | max Drift: ',num2str(MaxDrift1),'eV'];

%FineAlignLog
for i=1:length(FineAlignLog)
    if ~isempty(FineAlignLog{i})
        ZLPLog{end+1,1}= FineAlignLog{i};
    end
end

%ArtifactsLog
if ~isempty(ArtifactsLog{1})
    ZLPLog{end+1,1} = ArtifactsLog{1};
end

clearvars -except ZLP ZLP_old ZLPLog FWHM Energies PreZLP ZLPDrift ZLPExp Cut Fine
end